IF EXISTS
(
    SELECT *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'[dbo].V_EST_NF_ENT_FASES_ENTRADA')
)
    DROP VIEW [dbo].[V_EST_NF_ENT_FASES_ENTRADA];
GO
--SELECT * FROM V_EST_NF_ENT_FASES_ENTRADA WHERE DT_ENT ='2018-08-14' ORDER BY HORA_ENTRADA DESC
CREATE VIEW V_EST_NF_ENT_FASES_ENTRADA AS
SELECT
	EST_NF_ENT.CD_FILIAL AS FILIAL,
	EST_NF_ENT.NR_NF AS NOTA_FISCAL,
	GLB_MOV_OP.DS_MOV_OP,
	COALESCE(EST_NF_ENT_DANFE_PROVISORIO.NR_AUTORIZADOR,EST_NF_SAI_NFE.NR_AUTORIZADOR,EST_NF_ENT_NFE.NR_AUTORIZADOR) AS NR_AUTORIZADOR,
	COALESCE(EST_NF_ENT_DANFE_PROVISORIO.DT_EMIS_NF,EST_NF_ENT.DT_EMI_NF) AS DT_EMISSAO_DANFE, 
	COALESCE(EST_NF_ENT_DANFE_PROVISORIO.DT_CAD,EST_NF_ENT.DT_EMI_NF) AS DATA_IMPORTACAO_DANFE,
	CASE WHEN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO.DT_LIBERACAO IS NULL THEN
		''
	ELSE
		'TEVE DIVERGENCIA'
	END LIBERACAO_DIVERGENCIA,
	COALESCE(EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO.DT_LIBERACAO,EST_NF_ENT.DT_HR_CAD,EST_NF_ENT.DT_HR_CAD) AS DT_LIBERACAO,
	COALESCE(EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO.DT_CAD,EST_NF_ENT.DT_HR_CAD,EST_NF_ENT.DT_HR_CAD) AS DT_CONFIRMACAO_RECBTO,
	COALESCE(EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.DT_TRANSACAO,tchk.DT_CAD,EST_NF_ENT.DT_HR_CAD) AS HORA_CHECKIN,
	CASE WHEN ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO.CODIGO IS NULL THEN
		CASE WHEN ADM_ERRO_EST_NF_SAI.CODIGO IS NULL THEN
			''
		ELSE
			'TEVE ERRO NO PAINEL'
		END
	ELSE
		'TEVE ERRO NO PAINEL'
	END ERRO_PAINEL,
	ADM_ERRO.DTERRO AS DATA_ERRO_PAINEL,
	EST_NF_ENT.DT_HR_CAD AS HORA_ENTRADA,
	NM_USU AS USUARIO_ENTRADA,
	EST_NF_ENT.APLICATIVO,
	EST_NF_ENT.VERSAO_APLICATIVO,
	EST_NF_ENT.DT_ENT
FROM
	EST_NF_ENT LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON
	EST_NF_ENT.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT.CD_NF = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.CD_CTR
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO.CD_CTR
	LEFT OUTER JOIN ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR = ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO.CD_CTR
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO ON
	EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CONFIRMACAO_RECBTO.CD_CTR
	LEFT OUTER JOIN ADM_ERRO ON
	ADM_ERRO_EST_NF_ENT_DANFE_PROVISORIO.CODIGO = ADM_ERRO.CODIGO
	INNER JOIN GLB_USU ON
	EST_NF_ENT.CD_USU = GLB_USU.CD_USU
	INNER JOIN GLB_MOV_OP ON
	EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
	LEFT OUTER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF t ON
	EST_NF_ENT.CD_EMP = t.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = t.CD_FIL_DEST AND
	EST_NF_ENT.CD_NF = t.CD_NF_ENT
	LEFT OUTER JOIN EST_NF_SAI_CHECKIN_ENTRADA tchk ON
	T.CD_EMP = tchk.CD_EMP AND
	T.CD_FIL_ORIG = tchk.CD_FILIAL AND
	T.CD_NF_SAI = tchk.CD_NF
	LEFT OUTER JOIN ADM_ERRO_EST_NF_SAI ON
	ADM_ERRO_EST_NF_SAI.CODIGO = ADM_ERRO.CODIGO
	LEFT OUTER JOIN EST_NF_SAI_NFE ON
	t.CD_EMP = EST_NF_SAI_NFE.CD_EMP AND
	t.CD_FIL_ORIG = EST_NF_SAI_NFE.CD_FILIAL AND
	t.CD_NF_SAI = EST_NF_SAI_NFE.CD_NF 
	LEFT OUTER JOIN EST_NF_ENT_NFE ON
	EST_NF_ENT.CD_EMP = EST_NF_ENT_NFE.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = EST_NF_ENT_NFE.CD_FILIAL AND
	EST_NF_ENT.CD_NF = EST_NF_ENT_NFE.CD_NF 
